  package todo;

  import javax.microedition.lcdui.*;

  import javax.microedition.midlet.*;
  import javax.microedition.lcdui.*;
  import javax.microedition.io.*;
  import javax.microedition.rms.*;
  import java.io.*;

  public class todo extends javax.microedition.midlet.MIDlet
      implements CommandListener {

    Display display;

    // Ecrans : menu principal, liste des actions, dtails d'une action
    List menuPrincipal;
    List listeActions;
    Form detailsAction;

    // Commandes utilises par les crans
    Command cmdExit;
    Command cmdFerme;
    Command cmdOK;

    StringItem action;
    TextField avancement;
    Alert alert;

    // Adresse de la passerelle  la base de donnes ct serveur
    String uri = "socket://j2me.netinnovations.fr:4004";

    RecordStore rs;

    int enregID;
    String valeurAction;
    String valeurAvancement;

    private static final int ID_CHARGE = 0;
    private static final int ID_MODIFIE = 1;
    private static final int ID_SAUVE = 2;
    private static final int ID_SORT = 3;

    private final String RECORD_STORE_NAME = "Todo";

    public void startApp() {
      display = Display.getDisplay (this);

      // Commandes utilises par les crans
      // Commande "OK"
      cmdOK = new Command ("OK", Command.SCREEN,1);
      // Commande "Ferme"
      cmdFerme = new Command ("Ferme", Command.SCREEN,1);
      // Commande "Sort"
      cmdExit = new Command ("Sort", Command.EXIT,1);

      // Menu principal
      menuPrincipal = new List ("Menu", List.IMPLICIT);
      // Charge les donnes depuis le serveur
      menuPrincipal.append ("Charge", null);
      // Modifie les donnes en local sur le terminal mobile (mode non connect)
      menuPrincipal.append ("Modifie", null);
      // Sauvegarder les donnes modifies en local sur le serveur via Internet
      menuPrincipal.append ("Sauve", null);
      // Quitte le MIDlet
      menuPrincipal.append ("Sort", null);
      menuPrincipal.setCommandListener (this);

      // Liste des actions
      listeActions = new List ("Actions", List.IMPLICIT);
      listeActions.addCommand (cmdFerme);
      listeActions.setCommandListener (this);

      // Dtails d'une action
      detailsAction = new Form ("Action");
      action = new StringItem ("Action:", null);
      detailsAction.append (action);
      // Saisie de l'tat d'avancement de la tche
      avancement = new TextField ("Avancement:", null, 3, TextField.NUMERIC);
      detailsAction.append (avancement);
      detailsAction.addCommand (cmdOK);
      detailsAction.addCommand (cmdFerme);
      detailsAction.setCommandListener (this);

      // Alerte
      alert = new Alert (null);
      alert.setTimeout (Alert.FOREVER);

      // On dmarre par le menu principal ...
      display.setCurrent (menuPrincipal);

      try {
        rs = RecordStore.openRecordStore (RECORD_STORE_NAME, false);
      }
      catch (RecordStoreNotFoundException e) {
        // Erreur : Aucune donnes  charger depuis le serveur
        displayAlert (AlertType.ERROR, "Pas de donnes charges");
      }
      catch (RecordStoreException e) {
        // Erreur d'accs au Record store
        displayAlert (AlertType.ERROR, "Erreur");
      }
      try {
        // Rcupre les donnes depuis la passerelle Java se trouvant sur le serveur Internet
        filtreListeActions comparateur = new filtreListeActions();
        RecordEnumeration enum = rs.enumerateRecords (null, comparateur, false);
        while (enum.hasNextElement()) {
          String enreg = new String (enum.nextRecord());
          int position = enreg.indexOf ("\t");
          listeActions.append (enreg.substring (1, position), null);
        }
      }
      catch (RecordStoreNotOpenException e) {
        // Erreur : Tentative de lecture dans le Record store alors qu'il n'a pas t ouvert
        displayAlert (AlertType.ERROR, "Erreur - Record store non ouvert");
      }
      catch (InvalidRecordIDException e) {
        // Erreur : Identifiant du Record store invalide
        displayAlert (AlertType.ERROR, "Erreur - ID invalide");
      }
      catch (RecordStoreException e) {
      }
      finally {
        try {
          if (rs != null) rs.closeRecordStore();
        }
        catch (RecordStoreNotOpenException e) {
        }
        catch (RecordStoreException e) {
        }
      }
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
    }

    public void commandAction(Command cmd, Displayable d) {
      // Gestion du menu principal
      if (d == menuPrincipal) {
        if (cmd == List.SELECT_COMMAND) {
          switch (menuPrincipal.getSelectedIndex()) {
            case ID_CHARGE:
              // 1re tape : Charger les donnes depuis la passerelle Java se trouvant sur le serveur
              charge();
              break;
            case ID_MODIFIE:
              // 2me tape : Modifier les donnes en local, sur le terminal mobile
              display.setCurrent (listeActions);
              break;
            case ID_SAUVE:
              // 3me tape : Sauvegarder les donnes sur le serveur Internet via la passerelle Java
              sauve();
              break;
            case ID_SORT:
              // Etape finale : Sortie de l'application
              destroyApp(false);
              notifyDestroyed();
          }
        }
      }
      // Gestion de l'cran de la liste des actions
      if (d == listeActions) {
        if (cmd == cmdFerme) display.setCurrent (menuPrincipal);
        if (cmd == List.SELECT_COMMAND) ecranDetailsAction (listeActions.getSelectedIndex());
      }
      // Gestion de l'cran des dtails d'une action
      if (d == detailsAction) {
        if (cmd == cmdOK) modifie (avancement.getString());
        if (cmd == cmdFerme) display.setCurrent (listeActions);
      }
    }

    public void charge() {
      StreamConnection conn = null;
      InputStreamReader reader = null;
      OutputStreamWriter writer = null;
      RecordStore rs = null;
      String alertText = null;
      try {
        // Ouverture de la connexion
        conn = (StreamConnection)Connector.open (uri);
        reader = new InputStreamReader (conn.openInputStream());
        writer = new OutputStreamWriter (conn.openOutputStream());
        // Action demande au serveur : chargement des donnes
        writer.write (Integer.toString (ID_CHARGE) + "\n");
        writer.write (action + "\n");
        writer.flush();
        // Suppression du Record store
        try {
          RecordStore.deleteRecordStore (RECORD_STORE_NAME);
        }
        catch (RecordStoreNotFoundException e) {
        }
        catch (RecordStoreException e) {
        }
        // Chargement de la table
        try {
          // Cration d'un nouveau Record store
          rs = RecordStore.openRecordStore (RECORD_STORE_NAME, true);
          // Alimentation du Record store
          while (true) {
            String enreg = readLine (reader);
            if (enreg.length() == 0) break;
            StringBuffer buffer = new StringBuffer(" ");
            buffer.append (enreg);
            rs.addRecord(buffer.toString().getBytes(), 0, buffer.length());
          }
        }
        catch (RecordStoreNotFoundException e) {
        }
        catch (RecordStoreFullException e) {
        }
        catch (RecordStoreException e) {
        }
        if (rs == null) alertText = "Erreur de chargement des donnes";
      }
      catch (IOException e) {
      }
      finally {
        try {
          if (reader != null) reader.close();
          if (writer != null) writer.close();
          if (conn != null) conn.close();
        }
        catch (IOException e) {
        }
        try {
          if (rs != null) rs.closeRecordStore();
        }
        catch (RecordStoreNotOpenException e) {
        }
        catch (RecordStoreException e) {
        }
      }
      displayAlert(AlertType.INFO,"Donnes charges");
    }

    private void modifie (String avancement) {
      try {
        rs = RecordStore.openRecordStore (RECORD_STORE_NAME, false);
        String ancienEnreg = new String (rs.getRecord (enregID));
        int position = ancienEnreg.indexOf ("\t");
        valeurAction = ancienEnreg.substring (1, position);
        // Le code "U" permet de spcifier une modification des donnes.
        // Le caractre de tabulation (\t) permet de sparer le nom de la tche de son niveau d'avancement
        String chaine = "U" + valeurAction + "\t" + avancement;
        byte[] enreg = chaine.getBytes();
        rs.setRecord (enregID, enreg, 0, enreg.length);
        display.setCurrent (listeActions);
      }
      catch (RecordStoreNotOpenException e) {
        displayAlert (AlertType.ERROR, "Erreur");
      }
      catch (InvalidRecordIDException e) {
      }
      catch (RecordStoreException e) {
      }
      finally {
        try {
          if (rs != null) rs.closeRecordStore();
        }
        catch (RecordStoreNotOpenException e) {
        }
        catch (RecordStoreException e) {
        }
      }
    }

    private void ecranDetailsAction (int index) {
      valeurAction = listeActions.getString (index);
      try {
        rs = RecordStore.openRecordStore (RECORD_STORE_NAME, false);
        filtreDetailsAction filtre = new filtreDetailsAction (valeurAction);
        RecordEnumeration enum = rs.enumerateRecords (filtre, null, false);
        // Parcours chaque enregistrement du Record store
        if (enum.hasNextElement()) {
          enregID = enum.nextRecordId();
          String enreg = new String(rs.getRecord (enregID));
          // Le caractre de tabulation est utilis pour sparer les informations au sein d'une mme ligne
          int position = enreg.indexOf ("\t");
          action.setText (enreg.substring (1, position));
          valeurAvancement = enreg.substring (position + 1);
          avancement.setString (valeurAvancement);
          display.setCurrent (detailsAction);
        }
      }
      catch (RecordStoreNotFoundException e) {
        displayAlert (AlertType.ERROR, "Pas de donnes charges");
      }
      catch (RecordStoreException e) {
        displayAlert (AlertType.ERROR, "Erreur");
      }
      finally {
        try {
          if (rs != null) rs.closeRecordStore();
        }
        catch (RecordStoreNotOpenException e) {
        }
        catch (RecordStoreException e) {
        }
      }
    }

    public void sauve() {
      try {
        rs = RecordStore.openRecordStore (RECORD_STORE_NAME, false);
      }
      catch (RecordStoreNotFoundException e) {
        displayAlert(AlertType.ERROR, "Pas de donnes charges");
      }
      catch (RecordStoreException e) {
      }
      StreamConnection conn = null;
      OutputStreamWriter writer = null;
      try {
        conn = (StreamConnection)Connector.open (uri);
        writer = new OutputStreamWriter (conn.openOutputStream());
        writer.write (Integer.toString (ID_SAUVE) + "\n");
        filtreSauve filtre = new filtreSauve();
        RecordEnumeration enum = rs.enumerateRecords (filtre, null, false);
        while (enum.hasNextElement()) {
          String enreg = new String (enum.nextRecord());
          writer.write (enreg.substring(1) + "\n");
        }
        writer.write ("\n");
        displayAlert (AlertType.INFO, "Donnes sauves");
      }
      catch (RecordStoreNotFoundException e) {
        displayAlert (AlertType.ERROR, "Pas de table");
      }
      catch (RecordStoreNotOpenException e) {
      }
      catch (InvalidRecordIDException e) {
      }
      catch (RecordStoreException e) {
      }
      catch (IOException e) {
      }
      finally {
        if (rs != null) {
          try {
            rs.closeRecordStore();
          }
          catch (RecordStoreNotOpenException e) {
          }
          catch (RecordStoreException e) {
          }
        }
        try {
          if (writer != null) writer.close();
          if (conn != null) conn.close();
        }
        catch (IOException e) {
        }
      }
    }

    private void displayAlert(AlertType typeAlerte, String message) {
      alert.setType (typeAlerte);
      alert.setString (message);
      display.setCurrent (alert, menuPrincipal);
    }

    private String readLine(InputStreamReader stream)
        throws IOException {
      StringBuffer buffer = new StringBuffer();
      while (true) {
        int caractere = stream.read();
        if ((caractere < 0) || (caractere == '\n')) break;
        buffer.append ((char)caractere);
      }
      return buffer.toString();
    }

    class filtreDetailsAction implements RecordFilter {

      private String action;

      public filtreDetailsAction (String action) {
        this.action = action;
      }

      public boolean matches (byte[] candidate) {
        String enreg = new String (candidate);
        int position = enreg.indexOf ("\t");
        return enreg.substring (1, position).equals (action);
      }
    }

    class filtreSauve implements RecordFilter {

      public boolean matches (byte[] candidate) {
        return ((char)candidate[0] == 'U');
      }
    }

    class filtreListeActions implements RecordComparator {
      public int compare (byte[] enreg1, byte[] enreg2) {
        String chaine1 = new String (enreg1);
        int position = chaine1.indexOf ("\t");
        chaine1 = chaine1.substring (0, position);
        String chaine2 = new String (enreg2);
        position = chaine2.indexOf ("\t");
        chaine2 = chaine2.substring (0, position);
        int comparaison = chaine1.compareTo (chaine2);
        if (comparaison < 0) return PRECEDES;
        else if (comparaison > 0) return FOLLOWS;
        else return EQUIVALENT;
      }
    }
  }
